#!/bin/sh
# fixltconfig v1.1.3  (c) 8.11.99 by Andreas Ley  (u) 27.7.2000
# Fixes unwanted ltconfig features
# - don't add internal names, except on irix and linux
# - don't add path lists
# - generate shared libraries, not shared objects

usage()
{
	echo "Usage: `basename $0` [-h] [filename [...]]" >&2
	exit 1
}

set -- `getopt h $*` || usage

while :; do
	case $1 in
		-h)     sed '1d;s/^# *//;/^$/q' $0; usage;;
		--)     shift; break;;
	esac
done

test $# -eq 0 && set -- ltconfig

for file do
	#
	# Ok, this is difficult, so at least _some_ documentation here: :)
	#
	# 's/+h $soname//'
	#
	# This is to remove internal names from HP-UX shared libraries. Since we
	# usually rename them because ltconfig's numbering scheme does not
	# follow the version.release.patchlevel scheme, the name given is often
	# wrong and the library wouldn't bne found at runtime.
	#
	# 's/+b $install_libdir//'
	#
	# This removes path lists from HP-UX shared libaries. Since we often
	# move libraries (e.g. from /usr/segment/lib to /usr/machine/lib) after
	# installation, the path lists would usually be wrong.
	#
	# 's/\(.*-o $objdir\/\)$soname\(.*-bE.*\)'"'"'/\1shr.o\2 \&\& ar cr $objdir\/$soname $objdir\/shr.o'"'"'/'
	#
	# This rule changes the building process from shared objects to shared
	# libraries on AIX - because that's what we usually need.
	#
	# (OLD) 's/soname_spec='"'"'${libname}${release}.so'"'"'/soname_spec='"'"'${rpath}\/${libname}.so'"'"'/'
	# 's/soname_spec='"'"'${libname}${release}.so.$major'"'"'/soname_spec='"'"'${rpath}\/${libname}.so'"'"'/'
	#
	# This rule is a rather bad hack to add a full path to IRIX shared
	# libraries. We need the full path since there is no way to tell the
	# IRIX ld to write the path where the library was found into the
	# executable. We also mustn't use version numbers since the IRIX ld
	# always writes the soname to the executable so there's no chance to
	# link a binary in a way that always the current library version gets
	# used.
	#
	cp -p ${file} ${file}.orig && \
	sed \
	-e 's/+h $soname//' \
	-e 's/+b $install_libdir//' \
	-e 's/\(.*-o $objdir\/\)$soname\(.*-bE.*\)'"'"'/\1shr.o\2 \&\& ar cr $objdir\/$soname $objdir\/shr.o'"'"'/' \
	-e 's/soname_spec='"'"'${libname}${release}.so'"'"'/soname_spec='"'"'${rpath}\/${libname}.so'"'"'/' \
	-e 's/soname_spec='"'"'${libname}${release}.so.$major'"'"'/soname_spec='"'"'${rpath}\/${libname}.so'"'"'/' \
	${file}.orig >${file}
done

exit 0
